#ifndef _SYS_MMAN_H
#define _SYS_MMAN_H

#include <stdarg.h>
#include <stdint.h>
#include <sys/types.h>

#define MADV_NORMAL 0

#define MADV_RANDOM 1

#define MADV_SEQUENTIAL 2

#define MADV_WILLNEED 3

#define MADV_DONTNEED 4

#define MAP_SHARED 1

#define MAP_PRIVATE 2

#define MAP_TYPE 15

#define MAP_ANON 32

#define MAP_ANONYMOUS MAP_ANON

#define MAP_STACK 131072

#define MREMAP_MAYMOVE 1

#define MS_ASYNC 1

#define MS_INVALIDATE 2

#define MS_SYNC 4

#define MCL_CURRENT 1

#define MCL_FUTURE 2

#define POSIX_MADV_NORMAL 0

#define POSIX_MADV_RANDOM 1

#define POSIX_MADV_SEQUENTIAL 2

#define POSIX_MADV_WILLNEED 3

#define POSIX_MADV_WONTNEED 4

#if defined(__linux__)
#define PROT_READ 1
#endif

#if defined(__redox__)
#define PROT_READ 4
#endif

#if defined(__linux__)
#define PROT_WRITE 2
#endif

#if defined(__redox__)
#define PROT_WRITE 2
#endif

#if defined(__linux__)
#define PROT_EXEC 4
#endif

#if defined(__redox__)
#define PROT_EXEC 1
#endif

#if defined(__linux__)
#define PROT_NONE 0
#endif

#if defined(__redox__)
#define PROT_NONE 0
#endif

#if defined(__linux__)
#define MAP_FIXED 16
#endif

#if defined(__redox__)
#define MAP_FIXED 4
#endif

#if defined(__linux__)
#define MAP_FIXED_NOREPLACE 1048576
#endif

#if defined(__redox__)
#define MAP_FIXED_NOREPLACE 12
#endif

#if defined(__linux__)
#define MAP_POPULATE 32768
#endif

#if defined(__redox__)
#define MAP_POPULATE 31
#endif

#if defined(__linux__)
#define MAP_HUGETLB 262144
#endif

#if defined(__redox__)
#define MAP_HUGETLB 46
#endif

#if defined(__linux__)
#define MAP_NORESERVE 16384
#endif

#if defined(__linux__)
#define MADV_HUGEPAGE 14
#endif

#if defined(__linux__)
#define MADV_NOHUGEPAGE 15
#endif

#if defined(__linux__)
#define MADV_DONTDUMP 16
#endif

#if defined(__redox__)
#define MADV_DONTDUMP 5
#endif

#if defined(__linux__)
#define MADV_DODUMP 17
#endif

#if defined(__redox__)
#define MADV_DODUMP 6
#endif

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
 * Non-POSIX, see <https://www.man7.org/linux/man-pages/man2/madvise.2.html>.
 */
int madvise(void *addr, size_t len, int flags);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mlock.html>.
 */
int mlock(const void *addr, uintptr_t len);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mlockall.html>.
 */
int mlockall(int flags);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mmap.html>.
 */
void *mmap(void *addr, size_t len, int prot, int flags, int fildes, off_t off);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mprotect.html>.
 */
int mprotect(void *addr, size_t len, int prot);

/**
 * Non-POSIX, see <https://www.man7.org/linux/man-pages/man2/mremap.2.html>.
 */
void *mremap(void *old_address, uintptr_t old_size, uintptr_t new_size, int flags, ...);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/msync.html>.
 */
int msync(void *addr, size_t len, int flags);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mlock.html>.
 */
int munlock(const void *addr, uintptr_t len);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/mlockall.html>.
 */
int munlockall(void);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/munmap.html>.
 */
int munmap(void *addr, size_t len);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/shm_open.html>.
 */
int shm_open(const char *name, int oflag, mode_t mode);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/shm_unlink.html>.
 */
int shm_unlink(const char *name);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* _SYS_MMAN_H */

#include <bits/sys/mman.h>
