#ifndef _RELIBC_POLL_H
#define _RELIBC_POLL_H

#define POLLIN 1

#define POLLPRI 2

#define POLLOUT 4

#define POLLERR 8

#define POLLHUP 16

#define POLLNVAL 32

#define POLLRDNORM 64

#define POLLRDBAND 128

#define POLLWRNORM 256

#define POLLWRBAND 512

struct pollfd {
  int fd;
  short events;
  short revents;
};

typedef unsigned long nfds_t;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

int poll(struct pollfd *fds, nfds_t nfds, int timeout);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* _RELIBC_POLL_H */
