#ifndef _RELIBC_DLFCN_H
#define _RELIBC_DLFCN_H

#define RTLD_LAZY (1 << 0)

#define RTLD_NOW (1 << 1)

#define RTLD_NOLOAD (1 << 2)

#define RTLD_GLOBAL (1 << 8)

#define RTLD_LOCAL 0

#define RTLD_DEFAULT (void*)0

typedef struct {
  const char *dli_fname;
  void *dli_fbase;
  const char *dli_sname;
  void *dli_saddr;
} Dl_info;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

int dladdr(void *_addr, Dl_info *info);

void *dlopen(const char *cfilename, int flags);

void *dlsym(void *handle, const char *symbol);

int dlclose(void *handle);

char *dlerror(void);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* _RELIBC_DLFCN_H */
