#ifndef _RELIBC_WCTYPE_H
#define _RELIBC_WCTYPE_H

#include <wchar.h>

typedef uint32_t wctype_t;

typedef const int32_t *wctrans_t;

#define WEOF 4294967295u

#define WCTYPE_ALNUM 1

#define WCTYPE_ALPHA 2

#define WCTYPE_BLANK 3

#define WCTYPE_CNTRL 4

#define WCTYPE_DIGIT 5

#define WCTYPE_GRAPH 6

#define WCTYPE_LOWER 7

#define WCTYPE_PRINT 8

#define WCTYPE_PUNCT 9

#define WCTYPE_SPACE 10

#define WCTYPE_UPPER 11

#define WCTYPE_XDIGIT 12

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswalnum.html>.
 */
int iswalnum(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswalpha.html>.
 */
int iswalpha(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswblank.html>.
 */
int iswblank(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswcntrl.html>.
 */
int iswcntrl(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswctype.html>.
 */
int iswctype(wint_t wc, wctype_t desc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswdigit.html>.
 */
int iswdigit(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswgraph.html>.
 */
int iswgraph(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswlower.html>.
 */
int iswlower(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswprint.html>.
 */
int iswprint(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswpunct.html>.
 */
int iswpunct(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswspace.html>.
 */
int iswspace(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswupper.html>.
 */
int iswupper(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/iswxdigit.html>.
 */
int iswxdigit(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/towctrans.html>.
 */
wint_t towctrans(wint_t wc, wctrans_t trans);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/towlower.html>.
 */
wint_t towlower(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/towupper.html>.
 */
wint_t towupper(wint_t wc);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/wctrans.html>.
 *
 * # Safety
 * The caller must ensure that `class` is convertible to a slice reference, up
 * to and including a terminating nul.
 */
wctrans_t wctrans(const char *class_);

/**
 * See <https://pubs.opengroup.org/onlinepubs/9799919799/functions/wctype.html>.
 *
 * # Safety
 * The caller must ensure that `name` is convertible to a slice reference, up
 * to and including a terminating nul.
 */
wctype_t wctype(const char *name);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* _RELIBC_WCTYPE_H */
