#ifndef _RELIBC_GRP_H
#define _RELIBC_GRP_H

#include <sys/types.h>
#include <stdint.h>

struct group {
  char *gr_name;
  char *gr_passwd;
  gid_t gr_gid;
  char **gr_mem;
};

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct group *getgrgid(gid_t gid);

struct group *getgrnam(const char *name);

int getgrgid_r(gid_t gid,
               struct group *result_buf,
               char *buffer,
               uintptr_t buflen,
               struct group **result);

int getgrnam_r(const char *name,
               struct group *result_buf,
               char *buffer,
               uintptr_t buflen,
               struct group **result);

struct group *getgrent(void);

void endgrent(void);

void setgrent(void);

int getgrouplist(const char *user, gid_t group, gid_t *groups, int *ngroups);

int initgroups(const char *user, gid_t gid);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* _RELIBC_GRP_H */
